#import <Foundation/Foundation.h>
#import <os/log.h>

typedef NS_ENUM(NSUInteger, APXLOGLEVEL) {
    APX_INFO = 0,
    APX_DEBUG = 1,
    APX_WARN = 2,
    APX_ERROR = 3,
    APX_NONE = 9999
};

extern APXLOGLEVEL LOG_LEVEL;

#define PrintThread1 \
do { \
    if ([NSThread isMainThread]) { \
        os_log(OS_LOG_DEFAULT, "***MainThread*** %{public}s-%{public}u", __func__, __LINE__); \
    } else { \
        os_log(OS_LOG_DEFAULT, "+++BGThread queue:%{public}s+++ %{public}s,%{public}u", \
            dispatch_queue_get_label(DISPATCH_CURRENT_QUEUE_LABEL), \
            __func__, __LINE__); \
    } \
} while (0)


#define Loginfo(x) \
do { \
    os_log(OS_LOG_DEFAULT, "<APX INFO> %{public}s %{public}s:%{public}d", \
           [[x description] UTF8String], __FUNCTION__, __LINE__); \
} while (0)


#define Logdebug(x) \
do { \
    if (LOG_LEVEL <= APX_DEBUG) \
        os_log(OS_LOG_DEFAULT, "<APX DEBUG> %{public}s %{public}s:%{public}d", \
               [[x description] UTF8String], __FUNCTION__, __LINE__); \
} while (0)


#define Logwarn(x) \
do { \
    if (LOG_LEVEL <= APX_WARN) \
        os_log(OS_LOG_DEFAULT, "<APX WARN> %{public}s %{public}s:%{public}d", \
               [[x description] UTF8String], __FUNCTION__, __LINE__); \
} while (0)


#define Logerr(x) \
do { \
    if (LOG_LEVEL <= APX_ERROR) \
        os_log(OS_LOG_DEFAULT, "<APX ERROR> %{public}s %{public}s:%{public}d", \
               [[x description] UTF8String], __FUNCTION__, __LINE__); \
} while (0)


@interface APXLogger: NSObject
+(void) setLogLevel:(APXLOGLEVEL) logLevel;
@end
