#import "APXInfo.h"
#import "APXTypes.h"

typedef NS_ENUM(NSUInteger, APXEventType) {
    APXEventTypeSystem = 0,
    APXEventTypeCENavigation = 1,
    APXEventTypeNavigation = 2,
    APXEventTypeUserInteraction = 3,
    APXEventTypeApp = 4,
    APXEventTypeClient = 5,
    APXEventTypeAggregate = 6,
    APXEventTypePush = 7,
    APXEventTypeInApp = 8,
    APXEventTypeInline = 9,
    APXEventTypeNudge = 10,
    APXEventTypeInlineText = 11,
    APXEventTypeInlineCoachmark = 12,
    APXEventTypeWalkthrough = 13,
    APXEventTypeScreenshot = 14,
    APXEventTypeSurvey = 15,
    APXEventTypeUser = 16,
    APXEventTypeSession = 17,
    APXEventTypeChunk = 18,
    APXEventTypeCustomError = 19,
    APXEventTypeCrash = 20,
    APXEventTypeInternal = 21,
    APXEventTypeGoalsSatisfied = 22,
    APXEventTypeUserPropertiesSatisfied = 23,
    APXEventTypeUserPropertiesChanged = 24,
    APXEventTypeImmersive = 25,
    APXEventTypeOnBoarding = 26,
    APXEventTypeDownload = 27,
    APXEventTypeDelete = 28
};

#define APXENUMSTRING(x)   [APXEvent typeToString(x)]

@class APXEvent;

@protocol APXEventListener <NSObject>

-(void) onEvent: (APXEvent*) event;

@end

@protocol APXEventSource <NSObject>

-(void) logEvent:(NSString *) eventName info:(NSDictionary *) info time:(APXTime) time;

@end


@interface APXEvent : APXInfo 

+ (NSString*)stringFromType:(APXEventType)type;
+ (APXEventType)typeFromString:(NSString*)string;

- (instancetype)initWithType:(APXEventType)type;
- (APXTime)createdTime;
- (void)setCreatedTime:(APXTime)time;
- (APXEventType)eventType;
- (void)setEventType:(APXEventType)type;

@end


@interface APXSessionEvent : APXEvent

@end

@interface APXChunkEvent : APXEvent

@end

@interface APXSurveyEvent : APXEvent

@end

@interface APXImmersiveEvent : APXEvent

@end

@interface APXInlineEvent : APXEvent

@end

@interface APXInAppEvent : APXEvent

@end

@interface APXNudgeEvent : APXEvent

@end

@interface APXClientEvent : APXEvent

@end

@interface APXInternalEvent : APXEvent

@end

@interface APXAggregateEvent : APXEvent

@end

@interface APXOnBoardingEvent : APXEvent

@end

@interface APXDownloadEvent : APXEvent

@end

@interface APXDeleteEvent : APXEvent

@end
