#import <Foundation/Foundation.h>
#import "ApxorSDK/ApxorPlugin.h"

NS_ASSUME_NONNULL_BEGIN

@interface APXContextEvaluator : NSObject<ApxorPlugin>

@property (readwrite) dispatch_queue_t ceOpsSerialQueue;

+ (instancetype)sharedInstance;
- (void)parseConfiguration:(NSDictionary*)configuration forIdentifier:(NSString *)identifier;
- (void)parseTerminationConfiguration:(NSDictionary*)terminateConfig forConfigID:(NSString *) configId;
- (void)updateCountForConfigWithIdentifier:(NSString *)identifier;
- (void)updateConditionsForConfigWithIdentifier:(NSString *)identifier;
- (void)updateConditionsForConfigWithIdentifier:(NSString *)identifier WithScreenName:(NSString *)screenName;
- (NSString*)replaceMacros:(NSString*)text;
- (id)evaluateCommand:(NSString *)command withVariableMap:(NSDictionary *)variableMap;

@end

NS_ASSUME_NONNULL_END
